/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftbchunks.data.ProtectionOverride;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class ClaimedChunkManager {
    public static final LevelResource DATA_DIR = new LevelResource("ftbchunks");
    public final TeamManager teamManager;
    public final Map<UUID, FTBChunksTeamData> teamData;
    public final Map<ChunkDimPos, ClaimedChunk> claimedChunks;
    public Path dataDirectory;
    public Path localDirectory;
    private Map<ResourceKey<Level>, Pair<UUID, LongOpenHashSet>> forceLoadedChunks;

    public ClaimedChunkManager(TeamManager m) {
        this.teamManager = m;
        this.teamData = new HashMap<UUID, FTBChunksTeamData>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunk>();
        this.dataDirectory = this.getMinecraftServer().m_129843_(DATA_DIR);
        this.localDirectory = Platform.getGameFolder().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(this.localDirectory, new LinkOption[0])) {
                Files.createDirectories(this.localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initForceLoadedChunks(ServerLevel level) {
        int forceLoaded = 0;
        Pair<UUID, LongOpenHashSet> set = this.getForceLoadedChunks().get(level.m_46472_());
        if (set == null || level.m_7726_() == null) {
            return;
        }
        for (Long pos : (LongOpenHashSet)set.right()) {
            ChunkPos chunkPos = new ChunkPos(pos.longValue());
            FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", (UUID)set.left(), chunkPos.f_45578_, chunkPos.f_45579_, true);
        }
        level.m_7726_().m_8419_(false);
        FTBChunks.LOGGER.info("Force-loaded %d chunks in %s".formatted(forceLoaded, level.m_46472_().m_135782_()));
    }

    private FTBChunksTeamData loadTeamData(Team team) {
        Path path = this.dataDirectory.resolve(team.getId() + ".snbt");
        FTBChunksTeamData data = new FTBChunksTeamData(this, path, team);
        SNBTCompoundTag dataFile = SNBT.read((Path)path);
        if (dataFile != null) {
            data.deserializeNBT((CompoundTag)dataFile);
            this.teamData.put(team.getId(), data);
            return data;
        }
        return data;
    }

    public MinecraftServer getMinecraftServer() {
        return this.teamManager.server;
    }

    public FTBChunksTeamData getData(@Nullable Team team) {
        if (team == null) {
            throw new IllegalArgumentException("Team not found!");
        }
        FTBChunksTeamData data = this.teamData.get(team.getId());
        if (data == null) {
            data = this.loadTeamData(team);
            this.teamData.put(team.getId(), data);
        }
        return data;
    }

    public FTBChunksTeamData getData(ServerPlayer player) {
        return this.getData(FTBTeamsAPI.getPlayerTeam((ServerPlayer)player));
    }

    public boolean hasData(ServerPlayer player) {
        Team team = FTBTeamsAPI.getManager().getPlayerTeam(player.m_142081_());
        return team != null && this.teamData.containsKey(team.getId());
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    public Collection<ClaimedChunk> getAllClaimedChunks() {
        return this.claimedChunks.values();
    }

    public boolean getBypassProtection(UUID player) {
        return this.teamManager.getInternalPlayerTeam(player).getExtraData().m_128471_("BypassFTBChunksProtection");
    }

    public void setBypassProtection(UUID player, boolean bypass) {
        this.teamManager.getInternalPlayerTeam(player).getExtraData().m_128379_("BypassFTBChunksProtection", bypass);
        this.teamManager.getInternalPlayerTeam(player).save();
    }

    public boolean protect(@Nullable Entity entity, InteractionHand hand, BlockPos pos, Protection protection) {
        if (!(entity instanceof ServerPlayer) || ((Boolean)FTBChunksWorldConfig.DISABLE_PROTECTION.get()).booleanValue()) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)entity;
        boolean isFake = PlayerHooks.isFake((Player)player);
        if (isFake && ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).isOverride()) {
            return ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).getProtect();
        }
        ClaimedChunk chunk = this.getChunk(new ChunkDimPos(player.f_19853_, pos));
        if (chunk != null) {
            ProtectionOverride override = protection.override(player, pos, hand, chunk);
            if (override.isOverride()) {
                return override.getProtect();
            }
            return isFake || !this.getBypassProtection(player.m_142081_());
        }
        if (FTBChunksWorldConfig.noWilderness(player)) {
            ProtectionOverride override = protection.override(player, pos, hand, null);
            if (override.isOverride()) {
                return override.getProtect();
            }
            if (!isFake && this.getBypassProtection(player.m_142081_())) {
                return false;
            }
            player.m_5661_((Component)new TextComponent("You need to claim this chunk to interact with blocks here!"), true);
            return true;
        }
        return false;
    }

    public void updateForceLoadedChunks() {
        this.forceLoadedChunks = null;
    }

    public Map<ResourceKey<Level>, Pair<UUID, LongOpenHashSet>> getForceLoadedChunks() {
        if (this.forceLoadedChunks == null) {
            this.forceLoadedChunks = new HashMap<ResourceKey<Level>, Pair<UUID, LongOpenHashSet>>();
            for (ClaimedChunk chunk : this.claimedChunks.values()) {
                if (!chunk.isActuallyForceLoaded()) continue;
                Pair chunkPosSet = this.forceLoadedChunks.computeIfAbsent((ResourceKey<Level>)chunk.pos.dimension, k -> Pair.of((Object)chunk.teamData.getTeamId(), (Object)new LongOpenHashSet()));
                ((LongOpenHashSet)chunkPosSet.right()).add(ChunkPos.m_45589_((int)chunk.pos.x, (int)chunk.pos.z));
            }
            this.forceLoadedChunks = this.forceLoadedChunks.isEmpty() ? Collections.emptyMap() : this.forceLoadedChunks;
        }
        return this.forceLoadedChunks;
    }

    public boolean isChunkForceLoaded(ResourceKey<Level> dimension, int x, int z) {
        Pair<UUID, LongOpenHashSet> set = this.getForceLoadedChunks().get(dimension);
        return set != null && ((LongOpenHashSet)set.right()).contains(ChunkPos.m_45589_((int)x, (int)z));
    }
}

